/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.ModContent;
import dev.quarris.ppfluids.container.FluidFilterSlot;
import dev.quarris.ppfluids.mixins.ItemFilterAccessor;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class FluidFilter
extends ItemFilter {
    protected FluidPipeBlockEntity pipe;

    public FluidFilter(int size, ItemStack moduleItem, PipeBlockEntity pipe, boolean isDefaultWhitelist) {
        super(size, moduleItem, pipe);
        this.pipe = (FluidPipeBlockEntity)pipe;
        this.isWhitelist = isDefaultWhitelist;
        this.load();
    }

    public FluidFilter(int size, ItemStack moduleItem, FluidPipeBlockEntity pipe) {
        this(size, moduleItem, pipe, false);
    }

    public List<Slot> getSlots(int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.getSlots(); ++i) {
            slots.add((Slot)new FluidFilterSlot((IItemHandler)this, i, x + i % 9 * 18, y + i / 9 * 18));
        }
        return slots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<AbstractWidget> getButtons(final Screen gui, int x, int y, boolean rightAligned) {
        ArrayList<AbstractWidget> buttons = new ArrayList<AbstractWidget>();
        if (this.canModifyWhitelist) {
            Supplier<MutableComponent> whitelistText = () -> new TranslatableComponent("info.prettypipes." + (this.isWhitelist ? "whitelist" : "blacklist"));
            buttons.add((AbstractWidget)new Button(x - 20, y, 20, 20, (Component)whitelistText.get(), button -> {
                PacketButton.sendAndExecute((BlockPos)this.pipe.m_58899_(), (PacketButton.ButtonResult)PacketButton.ButtonResult.FILTER_CHANGE, (int[])new int[]{0});
                button.m_93666_((Component)whitelistText.get());
            }){

                public void m_7428_(PoseStack matrix, int x, int y) {
                    gui.m_96602_(matrix, (Component)new TranslatableComponent("info.ppfluids." + (FluidFilter.this.isWhitelist ? "whitelist" : "blacklist") + ".description").m_130940_(ChatFormatting.GRAY), x, y);
                }
            });
        }
        if (this.canPopulateFromInventories) {
            buttons.add((AbstractWidget)new Button(x - 42, y, 20, 20, (Component)new TranslatableComponent("info.prettypipes.populate"), button -> PacketButton.sendAndExecute((BlockPos)this.pipe.m_58899_(), (PacketButton.ButtonResult)PacketButton.ButtonResult.FILTER_CHANGE, (int[])new int[]{1})){

                public void m_7428_(PoseStack matrix, int x, int y) {
                    gui.m_96602_(matrix, (Component)new TranslatableComponent("info.prettypipes.populate.description").m_130940_(ChatFormatting.GRAY), x, y);
                }
            });
        }
        return buttons;
    }

    public void onButtonPacket(ItemFilter.IFilteredContainer menu, int id) {
        if (id == 0 && this.canModifyWhitelist) {
            ItemFilterAccessor accessor = (ItemFilterAccessor)((Object)this);
            this.isWhitelist = !this.isWhitelist;
            accessor.setModified(true);
            this.save();
        } else if (id == 1 && this.canPopulateFromInventories) {
            List<FluidFilter> filters = this.pipe.getFluidFilters();
            boolean changed = false;
            for (Direction dir : Direction.values()) {
                IFluidHandler handler = this.pipe.getFluidHandler(dir);
                if (handler == null) continue;
                block1: for (int i = 0; i < handler.getTanks(); ++i) {
                    FluidStack stack = handler.getFluidInTank(i);
                    if (stack.isEmpty() || this.isFluidFiltered(stack)) continue;
                    ItemStack fluidBucket = FluidUtil.getFilledBucket((FluidStack)stack);
                    for (FluidFilter filter : filters) {
                        if (!ItemHandlerHelper.insertItem((IItemHandler)filter, (ItemStack)fluidBucket, (boolean)false).m_41619_()) continue;
                        changed = true;
                        filter.save();
                        continue block1;
                    }
                }
            }
            if (changed) {
                menu.onFilterPopulated();
            }
        }
    }

    public boolean isPipeItemAllowed(ItemStack stack) {
        if (stack.m_41720_() == ModContent.FLUID_ITEM.get()) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(this::isPipeFluidAllowed).orElse(false);
        }
        return false;
    }

    public boolean isPipeFluidAllowed(FluidStack stack) {
        return this.isFluidFiltered(stack) == this.isWhitelist;
    }

    private boolean isItemFiltered(ItemStack stack) {
        Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
        return fluid.filter(this::isFluidFiltered).isPresent();
    }

    private boolean isFluidFiltered(FluidStack fluidStack) {
        for (ItemStackHandler itemStackHandler : this.pipe.getFluidFilters()) {
            for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
                ItemStack filter = itemStackHandler.getStackInSlot(i);
                Optional filteredFluid = FluidUtil.getFluidContained((ItemStack)filter);
                if (!filteredFluid.isPresent() || !((FluidStack)filteredFluid.get()).equals((Object)fluidStack)) continue;
                return true;
            }
        }
        return false;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("fluids")) {
            ListTag fluidList = nbt.m_128437_("fluids", 10);
            int size = Math.min(fluidList.size(), this.getSlots());
            for (int i = 0; i < size; ++i) {
                CompoundTag fluidNBT = fluidList.m_128728_(i);
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)fluidNBT);
                this.setStackInSlot(i, FluidUtil.getFilledBucket((FluidStack)fluid));
            }
            if (this.canModifyWhitelist) {
                this.isWhitelist = nbt.m_128471_("whitelist");
            }
            ((ItemFilterAccessor)((Object)this)).setModified(true);
            return;
        }
        super.deserializeNBT(nbt);
    }

    public static interface IFluidFilteredContainer
    extends ItemFilter.IFilteredContainer {
        public FluidFilter getFilter();

        default public void onFilterPopulated() {
        }
    }
}

